CREATE DATABASE ZamowieniaZmiana
GO

use ZamowieniaZmiana
GO

CREATE TABLE Kategorie (
	IDKategorii int IDENTITY (1, 1) NOT NULL ,
	OpisKategorii nvarchar (75) NULL 
)
GO

CREATE TABLE Klienci (
	IDKlienta int IDENTITY (1, 1) NOT NULL ,
	ImieKlienta nvarchar (25) NULL ,
	NazwiskoKlienta nvarchar (25) NULL ,
	AdresKlienta nvarchar (50) NULL ,
	MiastoKlienta nvarchar (30) NULL ,
	StanZamKlienta nvarchar (2) NULL ,
	KodPocztowyKlienta nvarchar (10) NULL ,
	NumKierKlienta smallint NULL ,
	TelefonKlienta nvarchar (8) NULL 
)
GO

CREATE TABLE Pracownicy (
	IDPracownika int IDENTITY (1, 1) NOT NULL ,
	ImiePracownika nvarchar (25) NULL ,
	NazwiskoPracownika nvarchar (25) NULL ,
	AdresPracownika nvarchar (50) NULL ,
	MiastoPracownika nvarchar (30) NULL ,
	StanZamPracownika nvarchar (2) NULL ,
	KodPocztowyPracownika nvarchar (10) NULL ,
	NumKierunkPracownika smallint NULL ,
	TelefonPracownika nvarchar (8) NULL 
)
GO

CREATE TABLE Dane_zamowien (
	NumerZamowienia int NOT NULL ,
	NumerProduktu int NOT NULL ,
	CenaZakupu money NULL ,
	ZamowionaIlosc smallint NULL 
)
GO

CREATE TABLE Dane_zamowien_archiwum (
	NumerZamowienia int NOT NULL ,
	NumerProduktu int NOT NULL ,
	CenaZakupu money NULL ,
	ZamowionaIlosc smallint NULL 
)
GO

CREATE TABLE Zamowienia (
	NumerZamowienia int IDENTITY (1, 1) NOT NULL ,
	DataZamowienia date NULL ,
	DataWysylki date NULL ,
	IDKlienta int NULL ,
	IDPracownika int NULL ,
	WartoscCalkowita money NULL 
)
GO

CREATE TABLE Zamowienia_archiwum (
	NumerZamowienia int NOT NULL ,
	DataZamowienia date NULL ,
	DataWysylki date NULL ,
	IDKlienta int NULL ,
	IDPracownika int NULL ,
	WartoscCalkowita money NULL 
)
GO

CREATE TABLE Dostawcy_produktow (
	NumerProduktu int NOT NULL ,
	IDDostawcy int NOT NULL ,
	CenaHurtowa money NULL ,
	TerminDostarczenia smallint NULL 
)
GO

CREATE TABLE Produkty (
	NumerProduktu int IDENTITY (1, 1) NOT NULL ,
	NazwaProduktu nvarchar (50) NULL ,
	OpisProduktu nvarchar (100) NULL ,
	CenaDetaliczna money NULL ,
	StanMagazynowy smallint NULL ,
	IDKategorii int NULL 
)
GO

CREATE TABLE Dostawcy (
	IDDostawcy int IDENTITY (1, 1) NOT NULL ,
	NazwaDostawcy nvarchar (25) NULL ,
	AdresDostawcy nvarchar (50) NULL ,
	MiastoDostawcy nvarchar (30) NULL ,
	StanSiedzDostawcy nvarchar (2) NULL ,
	KodPocztowyDostawcy nvarchar (10) NULL ,
	TelefonDostawcy nvarchar (15) NULL ,
	FaxDostawcy nvarchar (15) NULL ,
	StronaInterDostawcy ntext NULL ,
	EmailDostawcy nvarchar (50) NULL ,
) 
GO

ALTER TABLE Kategorie ADD 
	CONSTRAINT Kategorie_PK PRIMARY KEY    
	(
		IDKategorii
	)  
GO

ALTER TABLE Klienci ADD 
	CONSTRAINT Cust_Area_Code_Default DEFAULT (0) FOR NumKierKlienta,
	CONSTRAINT Klienci_PK PRIMARY KEY    
	(
		IDKlienta
	)  
GO

 CREATE  INDEX NumKierKlienta ON Klienci(NumKierKlienta)
GO

 CREATE  INDEX KodPocztowyKlienta ON Klienci(KodPocztowyKlienta)
GO

ALTER TABLE Pracownicy ADD 
	CONSTRAINT Emp_Area_Code_Default DEFAULT (0) FOR NumKierunkPracownika,
	CONSTRAINT Pracownicy_PK PRIMARY KEY    
	(
		IDPracownika
	)  
GO

 CREATE  INDEX NumKierunkPracownika ON Pracownicy(NumKierunkPracownika)
GO

 CREATE  INDEX KodPocztowyPracownika ON Pracownicy(KodPocztowyPracownika)
GO

ALTER TABLE Dane_zamowien ADD 
	CONSTRAINT OD_Order_Number_Default DEFAULT (0) FOR NumerZamowienia,
	CONSTRAINT OD_Product_Number_Default DEFAULT (0) FOR NumerProduktu,
	CONSTRAINT Quoted_Price_Default DEFAULT (0) FOR CenaZakupu,
	CONSTRAINT Quantity_Ordered_Default DEFAULT (0) FOR ZamowionaIlosc,
	CONSTRAINT Dane_zamowien_PK PRIMARY KEY    
	(
		NumerZamowienia,
		NumerProduktu
	)  
GO

 CREATE  INDEX OrdersDane_zamowien ON Dane_zamowien(NumerZamowienia)
GO

 CREATE  INDEX ProductsDane_zamowien ON Dane_zamowien(NumerProduktu)
GO

ALTER TABLE Dane_zamowien_archiwum ADD 
	CONSTRAINT ODA_Order_Number_Default DEFAULT (0) FOR NumerZamowienia,
	CONSTRAINT ODA_Product_Number_Default DEFAULT (0) FOR NumerProduktu,
	CONSTRAINT ODA_Quoted_Price_Default DEFAULT (0) FOR CenaZakupu,
	CONSTRAINT ODA_Quantity_Ordered_Default DEFAULT (0) FOR ZamowionaIlosc,
	CONSTRAINT Dane_zamowien_archiwum_PK PRIMARY KEY    
	(
		NumerZamowienia,
		NumerProduktu
	)  
GO

 CREATE  INDEX Zamowienia_archiwumDane_zamowien_archiwum ON Dane_zamowien_archiwum(NumerZamowienia)
GO

ALTER TABLE Zamowienia ADD 
	CONSTRAINT O_Customer_ID_Default DEFAULT (0) FOR IDKlienta,
	CONSTRAINT O_Employee_ID_Default DEFAULT (0) FOR IDPracownika,
	CONSTRAINT Order_Total_Default DEFAULT (0) FOR WartoscCalkowita,
	CONSTRAINT Zamowienia_PK PRIMARY KEY    
	(
		NumerZamowienia
	)  
GO

 CREATE  INDEX IDKlienta ON Zamowienia(IDKlienta)
GO

 CREATE  INDEX IDPracownika ON Zamowienia(IDPracownika)
GO

ALTER TABLE Zamowienia_archiwum ADD 
	CONSTRAINT OA_Order_Number_Default DEFAULT (0) FOR NumerZamowienia,
	CONSTRAINT OA_Customer_ID_Default DEFAULT (0) FOR IDKlienta,
	CONSTRAINT OA_Employee_ID_Default DEFAULT (0) FOR IDPracownika,
	CONSTRAINT OA_Order_Total_Default DEFAULT (0) FOR WartoscCalkowita,
	CONSTRAINT Zamowienia_archiwum_PK PRIMARY KEY    
	(
		NumerZamowienia
	)  
GO

 CREATE  INDEX IDKlienta ON Zamowienia_archiwum(IDKlienta)
GO

 CREATE  INDEX IDPracownika ON Zamowienia_archiwum(IDPracownika)
GO

ALTER TABLE Dostawcy_produktow ADD 
	CONSTRAINT PV_Product_Number_Default DEFAULT (0) FOR NumerProduktu,
	CONSTRAINT PV_Vendor_ID_Default DEFAULT (0) FOR IDDostawcy,
	CONSTRAINT Wholesale_Price_Default DEFAULT (0) FOR CenaHurtowa,
	CONSTRAINT Days_To_Deliver_Default DEFAULT (0) FOR TerminDostarczenia,
	CONSTRAINT Dostawcy_produktow_PK PRIMARY KEY    
	(
		NumerProduktu,
		IDDostawcy
	)  
GO

 CREATE  INDEX ProductsDostawcy_produktow ON Dostawcy_produktow(NumerProduktu)
GO

 CREATE  INDEX IDDostawcy ON Dostawcy_produktow(IDDostawcy)
GO

ALTER TABLE Produkty ADD 
	CONSTRAINT Retail_Price_Default DEFAULT (0) FOR CenaDetaliczna,
	CONSTRAINT Quantity_On_Hand_Default DEFAULT (0) FOR StanMagazynowy,
	CONSTRAINT P_Category_ID_Default DEFAULT (0) FOR IDKategorii,
	CONSTRAINT Products_PK PRIMARY KEY    
	(
		NumerProduktu
	)  
GO

 CREATE  INDEX IDKategorii ON Produkty(IDKategorii)
GO

ALTER TABLE Dostawcy ADD 
	CONSTRAINT Dostawcy_PK PRIMARY KEY    
	(
		IDDostawcy
	)  
GO

 CREATE  INDEX KodPocztowyDostawcy ON Dostawcy(KodPocztowyDostawcy)
GO

ALTER TABLE Dane_zamowien ADD 
	CONSTRAINT Dane_zamowien_FK00 FOREIGN KEY 
	(
		NumerZamowienia
	) REFERENCES Zamowienia (
		NumerZamowienia
	),
	CONSTRAINT Dane_zamowien_FK01 FOREIGN KEY 
	(
		NumerProduktu
	) REFERENCES Produkty (
		NumerProduktu
	)
GO

ALTER TABLE Dane_zamowien_archiwum ADD 
	CONSTRAINT Dane_zamowien_archiwum_FK00 FOREIGN KEY 
	(
		NumerZamowienia
	) REFERENCES Zamowienia_archiwum (
		NumerZamowienia
	)
GO

ALTER TABLE Zamowienia ADD 
	CONSTRAINT Zamowienia_FK00 FOREIGN KEY 
	(
		IDKlienta
	) REFERENCES Klienci (
		IDKlienta
	),
	CONSTRAINT Zamowienia_FK01 FOREIGN KEY 
	(
		IDPracownika
	) REFERENCES Pracownicy (
		IDPracownika
	)
GO

ALTER TABLE Dostawcy_produktow ADD 
	CONSTRAINT Dostawcy_produktow_FK00 FOREIGN KEY 
	(
		NumerProduktu
	) REFERENCES Produkty (
		NumerProduktu
	),
	CONSTRAINT Dostawcy_produktow_FK01 FOREIGN KEY 
	(
		IDDostawcy
	) REFERENCES Dostawcy (
		IDDostawcy
	)
GO

ALTER TABLE Produkty ADD 
	CONSTRAINT Produkty_FK00 FOREIGN KEY 
	(
		IDKategorii
	) REFERENCES Kategorie (
		IDKategorii
	)
GO

